import groovy.util.XmlParser
import groovy.util.XmlSlurper
import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale
import java.text.ParsePosition
import org.serviio.library.metadata.*
import org.serviio.library.online.*

/**
 * Crackle.com content URL extractor plugin. 
 * 
 * V1:  Based on Crackle Plugin for Plex
 * V2:  CDN location from XBMC Plugin
 * V3:  CDN location from bobo222
 * V4:  Web resource due to change in RSS
 * @author Mike_Metro
 * Version:  4.0
 */
class Crackle extends WebResourceUrlExtractor {
    
    final VALID_FEED_URL = '^(?:http://)?www\\.crackle\\.com/rss/media.*$'
	
    String getExtractorName() {
        return 'Crackle'
    }
    
    boolean extractorMatches(URL feedUrl) {
        return feedUrl ==~ VALID_FEED_URL
    }
    
    int getVersion() {
        return 4
    }
	
    WebResourceContainer extractItems(URL resourceUrl, int maxItemsToRetrieve) {
        List<WebResourceItem> items = []
        def itemsAdded = 0
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US)

        def slurper = new XmlSlurper()
        def rssXML = slurper.parse(resourceUrl.toString()).declareNamespace(media: "http://search.yahoo.com/mrss/")
        rssXML.channel.item.eachWithIndex { item , num ->
            
            items << new WebResourceItem(title: item.title[0].text(), releaseDate: dateFormat.parse(item.pubDate.text(), new ParsePosition(0)) , additionalInfo: ['CrackleId': item.guid,'thumbnail':item."media:thumbnail"[2].@url.text()])
            itemsAdded++
            if (maxItemsToRetrieve != -1 && itemsAdded >= maxItemsToRetrieve) return true
            return false
	}	

	return new WebResourceContainer(title: rssXML.channel.title.text() , items: items)
    }

    ContentURLContainer extractUrl(WebResourceItem item, PreferredQuality requestedQuality) {
        def thumbUrl = item.additionalInfo.thumbnail
	def resText = (requestedQuality == PreferredQuality.LOW) ? '360p' : '480p'
		
	def videoId = item.additionalInfo.CrackleId
	def contentUrl = thumbUrl.replaceAll('http://(.*?)\\.crackle\\.com(/.*?)_.*', 'http://wpcdn1-media-us-am.crackle.com$2')
	contentUrl += "_${resText}.mp4"	
	def cacheKey = "Crackle_${videoId}_${requestedQuality}"
	
	return new ContentURLContainer(contentUrl: contentUrl, thumbnailUrl: thumbUrl, expiresImmediately: true, cacheKey : cacheKey)
    }

    static void main(args) {
	// this is just to test
        Crackle extractor = new Crackle()

	WebResourceContainer container = extractor.extractItems( new URL("http://www.crackle.com/rss/media/Zm14PTUwMDAmZmNtdD04MiZmcD0xJmZ4PQ.rss"), 50)
        container.getItems().each {
	    println it.title	
            ContentURLContainer result = extractor.extractUrl(it, PreferredQuality.MEDIUM)
            //println result 
        }   
    }
}
